/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.universal.shader;

import gg.essential.universal.UGraphics;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.DirectFloat2Uniform;
import gg.essential.universal.shader.DirectFloat3Uniform;
import gg.essential.universal.shader.DirectFloat4Uniform;
import gg.essential.universal.shader.DirectFloatMatrixUniform;
import gg.essential.universal.shader.DirectFloatUniform;
import gg.essential.universal.shader.DirectIntUniform;
import gg.essential.universal.shader.DirectSamplerUniform;
import gg.essential.universal.shader.GlShader;
import gg.essential.universal.shader.SamplerUniform;
import gg.essential.universal.shader.UShader;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 M2\u00020\u0001:\u0001MBB\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J2\u0010\u0012\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b \u0010!J\u0019\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0019\u0010/\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b1\u0010\u0011J!\u00106\u001a\u00020\f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f02H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00107R$\u0010:\u001a\u0002082\u0006\u00109\u001a\u0002088\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010@R\u0016\u0010A\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010?R\u0018\u0010B\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u00107R\"\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010\u000b\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010?R\"\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020F0C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010ER\"\u0010H\u001a\u0002088\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010;\u001a\u0004\bI\u0010=\"\u0004\bJ\u0010KR\u0016\u0010L\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010?R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010@\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006N"}, d2={"Lgg/essential/universal/shader/GlShader;", "Lgg/essential/universal/shader/UShader;", "", "vertSource", "fragSource", "Lgg/essential/universal/shader/BlendState;", "blendState", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "program", "", "preLink", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lgg/essential/universal/shader/BlendState;Lkotlin/jvm/functions/Function1;)V", "bind", "()V", "createShader", "(Lkotlin/jvm/functions/Function1;)V", "textureUnit", "textureId", "doBindTexture$UniversalCraft_1_8_9_forge", "(II)V", "doBindTexture", "Lgg/essential/universal/shader/DirectFloat2Uniform;", "getFloat2UniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectFloat2Uniform;", "Lgg/essential/universal/shader/DirectFloat3Uniform;", "getFloat3UniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectFloat3Uniform;", "Lgg/essential/universal/shader/DirectFloat4Uniform;", "getFloat4UniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectFloat4Uniform;", "Lgg/essential/universal/shader/DirectFloatMatrixUniform;", "getFloatMatrixUniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectFloatMatrixUniform;", "Lgg/essential/universal/shader/DirectFloatUniform;", "getFloatUniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectFloatUniform;", "Lgg/essential/universal/shader/DirectIntUniform;", "getIntUniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/DirectIntUniform;", "Lgg/essential/universal/shader/SamplerUniform;", "getSamplerUniformOrNull", "(Ljava/lang/String;)Lgg/essential/universal/shader/SamplerUniform;", "uniformName", "getUniformLocation", "(Ljava/lang/String;)Ljava/lang/Integer;", "unbind", "Lkotlin/Function0;", "block", "withProgramBound$UniversalCraft_1_8_9_forge", "(Lkotlin/jvm/functions/Function0;)V", "withProgramBound", "Lgg/essential/universal/shader/BlendState;", "", "<set-?>", "bound", "Z", "getBound", "()Z", "fragShader", "I", "Ljava/lang/String;", "prevActiveTexture", "prevBlendState", "", "prevTextureBindings", "Ljava/util/Map;", "Lgg/essential/universal/shader/DirectSamplerUniform;", "samplers", "usable", "getUsable", "setUsable", "(Z)V", "vertShader", "Companion", "UniversalCraft 1.8.9-forge"})
@SourceDebugExtension(value={"SMAP\nGlShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlShader.kt\ngg/essential/universal/shader/GlShader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class GlShader
implements UShader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String vertSource;
    @NotNull
    private final String fragSource;
    @NotNull
    private final BlendState blendState;
    private int program;
    private int vertShader;
    private int fragShader;
    @NotNull
    private Map<String, DirectSamplerUniform> samplers;
    private boolean usable;
    private boolean bound;
    private int prevActiveTexture;
    @NotNull
    private Map<Integer, Integer> prevTextureBindings;
    @Nullable
    private BlendState prevBlendState;
    private static final boolean CORE = UGraphics.isOpenGl21Supported();

    public GlShader(@NotNull String vertSource, @NotNull String fragSource, @NotNull BlendState blendState, @NotNull Function1<? super Integer, Unit> preLink) {
        Intrinsics.checkNotNullParameter(vertSource, "vertSource");
        Intrinsics.checkNotNullParameter(fragSource, "fragSource");
        Intrinsics.checkNotNullParameter(blendState, "blendState");
        Intrinsics.checkNotNullParameter(preLink, "preLink");
        this.vertSource = vertSource;
        this.fragSource = fragSource;
        this.blendState = blendState;
        this.program = UGraphics.glCreateProgram();
        this.vertShader = UGraphics.glCreateShader(35633);
        this.fragShader = UGraphics.glCreateShader(35632);
        this.samplers = new LinkedHashMap();
        this.prevTextureBindings = new LinkedHashMap();
        this.createShader(preLink);
    }

    @Override
    public boolean getUsable() {
        return this.usable;
    }

    public void setUsable(boolean bl) {
        this.usable = bl;
    }

    public final boolean getBound() {
        return this.bound;
    }

    @Override
    public void bind() {
        this.prevActiveTexture = GL11.glGetInteger(34016);
        for (DirectSamplerUniform sampler : this.samplers.values()) {
            this.doBindTexture$UniversalCraft_1_8_9_forge(sampler.getTextureUnit(), sampler.getTextureId());
        }
        this.prevBlendState = BlendState.Companion.active();
        this.blendState.activate();
        UGraphics.glUseProgram(this.program);
        this.bound = true;
    }

    public final void doBindTexture$UniversalCraft_1_8_9_forge(int textureUnit, int textureId) {
        UGraphics.setActiveTexture(33984 + textureUnit);
        this.prevTextureBindings.computeIfAbsent(textureUnit, arg_0 -> GlShader.doBindTexture$lambda$0(doBindTexture.1.INSTANCE, arg_0));
        UGraphics.bindTexture(textureId);
    }

    @Override
    public void unbind() {
        for (Map.Entry<Integer, Integer> entry : this.prevTextureBindings.entrySet()) {
            int textureUnit = ((Number)entry.getKey()).intValue();
            int textureId = ((Number)entry.getValue()).intValue();
            UGraphics.setActiveTexture(33984 + textureUnit);
            UGraphics.bindTexture(textureId);
        }
        this.prevTextureBindings.clear();
        UGraphics.setActiveTexture(this.prevActiveTexture);
        BlendState blendState = this.prevBlendState;
        if (blendState != null) {
            blendState.activate();
        }
        UGraphics.glUseProgram(0);
        this.bound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withProgramBound$UniversalCraft_1_8_9_forge(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withProgramBound$UniversalCraft_1_8_9_forge = false;
        if (this.getBound()) {
            block.invoke();
        } else {
            int prevProgram = GL11.glGetInteger(35725);
            try {
                UGraphics.glUseProgram(this.program);
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart(1);
                UGraphics.glUseProgram(prevProgram);
                InlineMarker.finallyEnd(1);
            }
        }
    }

    private final Integer getUniformLocation(String uniformName) {
        int loc = CORE ? GL20.glGetUniformLocation(this.program, uniformName) : ARBShaderObjects.glGetUniformLocationARB(this.program, uniformName);
        return loc == -1 ? null : Integer.valueOf(loc);
    }

    @Override
    @Nullable
    public DirectIntUniform getIntUniformOrNull(@NotNull String name) {
        DirectIntUniform directIntUniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directIntUniform = new DirectIntUniform(p0);
        } else {
            directIntUniform = null;
        }
        return directIntUniform;
    }

    @Override
    @Nullable
    public DirectFloatUniform getFloatUniformOrNull(@NotNull String name) {
        DirectFloatUniform directFloatUniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directFloatUniform = new DirectFloatUniform(p0);
        } else {
            directFloatUniform = null;
        }
        return directFloatUniform;
    }

    @Override
    @Nullable
    public DirectFloat2Uniform getFloat2UniformOrNull(@NotNull String name) {
        DirectFloat2Uniform directFloat2Uniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directFloat2Uniform = new DirectFloat2Uniform(p0);
        } else {
            directFloat2Uniform = null;
        }
        return directFloat2Uniform;
    }

    @Override
    @Nullable
    public DirectFloat3Uniform getFloat3UniformOrNull(@NotNull String name) {
        DirectFloat3Uniform directFloat3Uniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directFloat3Uniform = new DirectFloat3Uniform(p0);
        } else {
            directFloat3Uniform = null;
        }
        return directFloat3Uniform;
    }

    @Override
    @Nullable
    public DirectFloat4Uniform getFloat4UniformOrNull(@NotNull String name) {
        DirectFloat4Uniform directFloat4Uniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directFloat4Uniform = new DirectFloat4Uniform(p0);
        } else {
            directFloat4Uniform = null;
        }
        return directFloat4Uniform;
    }

    @Override
    @Nullable
    public DirectFloatMatrixUniform getFloatMatrixUniformOrNull(@NotNull String name) {
        DirectFloatMatrixUniform directFloatMatrixUniform;
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            Integer n2 = n;
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            directFloatMatrixUniform = new DirectFloatMatrixUniform(p0);
        } else {
            directFloatMatrixUniform = null;
        }
        return directFloatMatrixUniform;
    }

    @Override
    @Nullable
    public SamplerUniform getSamplerUniformOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        DirectSamplerUniform directSamplerUniform = this.samplers.get(name);
        if (directSamplerUniform != null) {
            DirectSamplerUniform directSamplerUniform2;
            DirectSamplerUniform it = directSamplerUniform2 = directSamplerUniform;
            boolean bl = false;
            return it;
        }
        Integer n = this.getUniformLocation(name);
        if (n == null) {
            return null;
        }
        int loc = n;
        DirectSamplerUniform uniform = new DirectSamplerUniform(loc, this.samplers.size(), this);
        this.samplers.put(name, uniform);
        return uniform;
    }

    private final void createShader(Function1<? super Integer, Unit> preLink) {
        Object object;
        Pair[] object22 = new Pair[]{TuplesKt.to(this.vertShader, this.vertSource), TuplesKt.to(this.fragShader, this.fragSource)};
        for (Pair pair : CollectionsKt.listOf(object22)) {
            int shader = ((Number)pair.component1()).intValue();
            String source = (String)pair.component2();
            if (CORE) {
                GL20.glShaderSource(shader, source);
            } else {
                ARBShaderObjects.glShaderSourceARB(shader, source);
            }
            UGraphics.glCompileShader(shader);
            if (UGraphics.glGetShaderi(shader, 35713) != 1) {
                String string = UGraphics.glGetShaderInfoLog(shader, 32768);
                System.out.println((Object)string);
                return;
            }
            UGraphics.glAttachShader(this.program, shader);
        }
        preLink.invoke((Integer)this.program);
        UGraphics.glLinkProgram(this.program);
        if (CORE) {
            GL20.glDetachShader(this.program, this.vertShader);
            GL20.glDetachShader(this.program, this.fragShader);
            GL20.glDeleteShader(this.vertShader);
            GL20.glDeleteShader(this.fragShader);
        } else {
            ARBShaderObjects.glDetachObjectARB(this.program, this.vertShader);
            ARBShaderObjects.glDetachObjectARB(this.program, this.fragShader);
            ARBShaderObjects.glDeleteObjectARB(this.vertShader);
            ARBShaderObjects.glDeleteObjectARB(this.fragShader);
        }
        if (UGraphics.glGetProgrami(this.program, 35714) != 1) {
            object = UGraphics.glGetProgramInfoLog(this.program, 32768);
            System.out.println(object);
            return;
        }
        if (CORE) {
            GL20.glValidateProgram(this.program);
        } else {
            ARBShaderObjects.glValidateProgramARB(this.program);
        }
        if (UGraphics.glGetProgrami(this.program, 35715) != 1) {
            object = UGraphics.glGetProgramInfoLog(this.program, 32768);
            System.out.println(object);
            return;
        }
        this.setUsable(true);
    }

    private static final Integer doBindTexture$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgg/essential/universal/shader/GlShader$Companion;", "", "<init>", "()V", "", "CORE", "Z", "getCORE", "()Z", "UniversalCraft 1.8.9-forge"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getCORE() {
            return CORE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

